// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedure for adding individual keys to a key ring.
//....................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer3;
extern	LPBYTE				lpKeyBuffer4;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	BYTE				TypeKey;
extern	DWORD				dwPublicDeleted;
extern	DWORD				dwSecretDeleted;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BYTE				KeySID;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPBYTE				lpIndexFile1;
extern	LPBYTE				lpRingFile1;
extern	HANDLE				hIdxHandle1;
extern	HANDLE				hKeyHandle1;
extern	DWORD				dwIdxOffset1;
extern	BOOL				bProcessInProgress;
extern	DWORD				dwRecordLength1;
extern	BOOL				bBackupFiles;
extern	TCHAR				szDestination[MAX_PATH];

// Variables used by the add key procedures.
//..........................................
LARGE_INTEGER	    liNextKey;
LPBYTE				lpKeyBufferDup1;
LPBYTE				lpKeyBufferDup2;
LPBYTE				lpKeyBufferDup3;
LPBYTE				lpKeyBufferDup4;
LPBYTE				lpN1Ptr;
LPBYTE				lpNextUserId;
DWORD				dwN1PcktLength;
DWORD				dwSizeOfKey;
HANDLE				hAddFromHandle;
BOOL				bSkipKey;
DWORD				dwPacketLength;
DWORD				dwSizeNewKey;
BOOL				bKeysAdded;
BOOL				bNewStuffAdded;
BOOL				bNewKeyAdded;
BOOL				bKeysMerged;
BOOL				bHaveUserId;
BOOL				bHaveCompSig;
LPBYTE				lpN3Offset;
DWORD				dwN3Bytes;
DWORD				dwN3Bits;
BYTE				TypePacket;
BYTE				SigId1[8];
TCHAR				szKeyFile[MAX_PATH];
DWORD				dwSource;
BOOL				bConvertedFile;

// Define the 3 byte trust packet to be added to the public key ring.
//...................................................................
BYTE				TrustPacket[3] = {0xb0, 0x01, 0x00};

// Add keys to a key ring.
//........................
VOID AddKeysToAKeyRing()
{
	LARGE_INTEGER	li;
	OPENFILENAME	ofn;
	BOOL			bResult;
	BOOL			bError;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	DWORD			dwCtb_Byte;
	DWORD			dwOldHelpTopic;
	DWORD			dwErrorCode;
	DWORD			dwTempEAX;
	DWORD			dwTempEDX;
	LPBYTE			lpTempEDI;
	BOOL			bProcessedKeyFile;
	UINT			uiMessage;
	BYTE			TempCTB;
	BYTE			TempByte;
	TCHAR			szOutBuff[768];
	TCHAR			szStatement[128];

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	bProcessedKeyFile = FALSE;
	bBackupFiles = FALSE;
	bKeysAdded = FALSE;
	bConvertedFile = FALSE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_ADDKEYSTOKEYRING);

	// Allocate memory for the read, write, and merge buffers.
	//........................................................
	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer4 = AllocateMemory(SIZE_KEY_BUFF);

	if (!lpKeyBuffer1 || !lpKeyBuffer3 || !lpKeyBuffer4)
	{
		goto AddKeysEnd;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szKeyFile;
	ofn.nMaxFile = sizeof(szKeyFile);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Key or Key Ring Files [.rsakey;.rng;.pkr;.skr]\0*.rsakey;*.rng;*.pkr;*.skr\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Open a Key or Key Ring File to Add to a Key Ring");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
				 OFN_HIDEREADONLY);
	ofn.lpstrDefExt = TEXT("rsakey");
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// If we are procesing a file that came from clipboard data
	// we do not have to select one.
	//.........................................................
	if (dwSource == FROM_CLIPBOARD)
	{
		goto SkipDialogBox;
	}
	// Get the key file to add to a key ring and check it out.
	//........................................................
	while(TRUE)
	{
		ZeroMemory(&szKeyFile,sizeof(szKeyFile));

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto AddKeysEnd;
		}
		// Save the dir name for the next dialog box.
		//...........................................
		SaveDirName((LPBYTE)&szKeyFile,SAVE_SOURCE,TRUE);

		SkipDialogBox:

		// Make sure we have a valid key file.
		//....................................
		hAddFromHandle = CreateMyFile((LPTSTR)&szKeyFile,GENERIC_READ,0,NULL,OPEN_EXISTING,
									   FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hAddFromHandle)
		{
			goto AddKeysEnd;
		}
		// Read the file header.
		//......................
		bResult = ReadMyFile((LPTSTR)szKeyFile,hAddFromHandle,lpKeyBuffer3,16,
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto AddKeysEnd;
		}
		// File with no data.
		//...................
		if (dwBytesRead == 0)
		{
			goto FileError;
		}
		lpKeyBufferDup3 = lpKeyBuffer3;

		// See if we have a valid public or secret key CTB.
		//.................................................
		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempCTB != CTB_SECRET_KEY && TempCTB != CTB_PUBLIC_KEY)
		{
		  FileError:
			SetLastError(IDS_NOTVALIDKEYFILE);
			ErrorProcedure((LPTSTR)&szKeyFile,IDS_ADDKEYPROC,MB_OK);
			CloseMyHandle((LPTSTR)&szKeyFile,hAddFromHandle);
			hAddFromHandle = 0;
			continue;
		}
		// Check out the file to see if we can process it.
		//................................................
		bError = CheckOutTheFile();
		
		if (bError)
		{
			if (dwSource == FROM_CLIPBOARD)
			{
				goto AddKeysEnd;
			}
			else
			{
				CloseMyHandle((LPTSTR)&szKeyFile,hAddFromHandle);
				hAddFromHandle = 0;
				continue;
			}
		}
		// We have a valid file.
		//......................
		break;
	}
	bProcessedKeyFile = TRUE;

	// Setup the type of key file and move the file pointer for
	// the public or secret key ring to the end for appending
	// keys to.
	//.........................................................
	if (TempCTB == CTB_PUBLIC_KEY)
	{
		TypeKey = PUBLIC_KEY;
		SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(lpRingFile1,hKeyHandle1,li.QuadPart,FILE_END);
		if (li.QuadPart == -1)
		{
			goto AddKeysEnd;
		}
	}
	else
	{
		TypeKey = SECRET_KEY;
		SetUpGroup(SECRET_KEY,INDEX_KEY,GROUP_ONE);
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer(lpRingFile1,hKeyHandle1,li.QuadPart,FILE_END);
		if (li.QuadPart == -1)
		{
			goto AddKeysEnd;
		}
	}
	// Start out with no keys deleted.
	//................................
	dwPublicDeleted = 0;
	dwSecretDeleted = 0;

	// Setup the modeless dialog box for adding keys to the key ring.
	//...............................................................
	hDialogModeLess = CreateDialog(hInst,TEXT("ADDKEYSTOKEYRING"),hMainWindow,
								  (DLGPROC)AddKeysToKeyRingProc);
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto AddKeysEnd;
	}
	// Rewind the file to add from.
	//.............................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto AddKeysEnd;
	}
	// Go into a loop to process the file.
	//....................................
	liNextKey.QuadPart = 0;

	while(TRUE)
	{
		EmptyTheMessageQue();
		lpKeyBufferDup3 = lpKeyBuffer3;
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		bResult = ReadMyFile((LPTSTR)&szKeyFile,hAddFromHandle,
							  lpKeyBuffer3,SIZE_KEY_BUFF,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto AddKeysEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Determine the size of the whole key, including user ids,
		// trust packets, and signatures.
		//.........................................................
		dwSizeOfKey = FindTheNextKey();
		if (dwSizeOfKey == 0)
		{
			goto AddKeysEnd;
		}
		// Now flush the read buffer and read in only the length
		// of this key. Makes it easier when transferring the key
		// to a buffer.
		//.......................................................
		li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,
										liNextKey.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto AddKeysEnd;
		}
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		bResult = ReadMyFile((LPTSTR)&szKeyFile,hAddFromHandle,
							  lpKeyBuffer3,dwSizeOfKey,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto AddKeysEnd;
		}
		liNextKey.LowPart += dwSizeOfKey;

		// See if we have to skip this key.
		//................................
		if (bSkipKey)
		{
			li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,
										    liNextKey.QuadPart,FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				goto AddKeysEnd;
			}
			bSkipKey = FALSE;
			continue;
		}
		// Check the common elements of the key here.
		//...........................................
		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		TempByte,cl
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		// If we have mixed keys in the file we cannot process
		// the file.
		//.....................................................
		dwErrorCode = 0;

		if (TypeKey == PUBLIC_KEY && TempCTB == CTB_SECRET_KEY)
		{
			dwErrorCode = IDS_NOSECRETTOPUBLIC;
		}
		else if (TypeKey == SECRET_KEY && TempCTB == CTB_PUBLIC_KEY)
		{
			dwErrorCode = IDS_NOPUBLICTOSECRET;
		}
		if (dwErrorCode)
		{
			SetLastError(dwErrorCode);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			goto AddKeysEnd;
		}
		// Determine the length of the length field.
		//..........................................
		GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

		__asm
		{
			add		eax,edx
			add		eax,CTB_SIZE
			mov		dwPacketLength,eax
			mov		edi,lpKeyBufferDup3
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpKeyBufferDup3,edi
		}
		// Version must be 2 or 3.
		//........................
		if (*lpKeyBufferDup3 != VERSION_OLD && 
			*lpKeyBufferDup3 != VERSION_NEW)
		{
			dwErrorCode = IDS_UNSUPPORTEDVERSIONKEY;
			goto SkipError;
		}
		// Check the algorithm byte to make sure it is RSA.
		//.................................................
		lpKeyBufferDup3 += (VERSION_SIZE + TIMESTAMP_SIZE + VALIDITY_SIZE);

		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			cmp		bConvertedFile,1
			je		L1
			and		al,0x01
		L1:	mov		TempByte,al
		}
		if (TempByte != RSA_ALGORITHM)
		{
			dwErrorCode = IDS_NONRSAALGORITHMKEY;
			goto SkipError;
		}
		// Check out modulus n and exponent e.
		//....................................
		__asm
		{
			mov		edi,lpKeyBufferDup3
			add		edi,ALGORITHM_SIZE
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			mov		lpN3Offset,edi
			xchg	ah,al
			mov		dwN3Bits,eax
			add		eax,7
			shr		eax,3
			mov		dwN3Bytes,eax
			add		edi,eax
			mov		lpKeyBufferDup3,edi
		}
		if (dwN3Bytes == 0)
		{
		  MpiError:
			SetLastError(IDS_MPIEQUALSZERO);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			goto AddKeysEnd;
		}
		if (dwN3Bytes > MAX_MOD_BYTES)
		{
			dwErrorCode = IDS_MODULUSNTO0BIG;

		  SkipError:
			SetLastError(dwErrorCode);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,
										    liNextKey.QuadPart,FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				goto AddKeysEnd;
			}
			continue;
		}
		if (dwN3Bits < MIN_BITS)
		{
			dwErrorCode = IDS_MODULUSNTOOSMALL;
			goto SkipError;
		}
		// Get and save the 8 byte key id for our search for
		// duplicate keys.
		//..................................................
		dwErrorCode = IDS_EXPONENTETOOBIG;
		__asm
		{
			mov		edi,lpKeyBufferDup3
			sub		edi,KEY_ID_SIZE
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr[edi+4]
			mov		dword ptr KeySID,eax
			mov		dword ptr KeySID[4],edx
			add		edi,KEY_ID_SIZE

			// Check out exponent e.
			//......................
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			add		eax,7
			shr		eax,3
			jz		MpiError
			cmp		eax,MAX_E_BYTES
			ja		SkipError
			add		edi,eax
			mov		lpKeyBufferDup3,edi
		}
		// If it is a secret key, check the enciphering algorithm
		// to see if we can handle it.
		//........................................................
		if (TypeKey == SECRET_KEY)
		{
			if (*lpKeyBufferDup3 != NO_ENCRYPTION &&
				*lpKeyBufferDup3 != TSC_ALGORITHM)
			{
				dwErrorCode = IDS_UNKNOWNALGORITHMFORSECRETCOMPONENTS;
				goto SkipError;
			}
		}
		bNewStuffAdded = FALSE;
		bNewKeyAdded = FALSE;
		bKeysMerged = FALSE;

		// Reset lpKeyBufferDup3 to point to start of key.
		//................................................
		lpKeyBufferDup3 = lpKeyBuffer3;

		// See if we have a duplicate of this key in the key ring.
		// We do this by checking the key id index file.
		//..............................................
		li.QuadPart = SearchMyFileBinary(lpIndexFile1,&KeySID,KEY_ID_SIZE,hIdxHandle1,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto AddKeysEnd;
		}
		// If we have a match we have to compare the keys a packet
		// at a time to see if they are different. We may have to
		// merge packets from the various keys, ie. has a new id,
		// sig, or compromise sig.
		//........................................................
		if (li.QuadPart != 0)
		{
			// We have a match. Get and merge the keys.
			//.........................................
			dwIdxOffset1 = li.HighPart;
			dwBytesRead = ReadIndex1();
			if (dwBytesRead == -1)
			{
				goto AddKeysEnd;
			}
			dwBytesRead = ReadRecord1();
			if (dwBytesRead == -1)
			{
				goto AddKeysEnd;
			}
			// Merge the two keys. Original key from key ring in
			// lpKeyBuffer1. New key from file in lpKeyBuffer3.
			// Use lpKeyBuffer4 for the merged key packets.
			//..................................................
			bKeysMerged = TRUE;
			bResult = MergeTheKeys();
			if (!bResult)
			{
				goto AddKeysEnd;
			}
		}
		else
		{
			// No matching key. Move this packet to lpKeyBuffer4
			// where we will build the new key. We have a new
			// key to add.
			//..................................................
			bNewKeyAdded = TRUE;
			lpKeyBufferDup4 = lpKeyBuffer4;
			lpKeyBufferDup3 = lpKeyBuffer3;
			CopyMemory(lpKeyBufferDup4,lpKeyBuffer3,dwPacketLength);
			lpKeyBufferDup4 += dwPacketLength;
			lpKeyBufferDup3 += dwPacketLength;
			dwSizeOfKey -= dwPacketLength;
			dwSizeNewKey = dwPacketLength;

			// If the size of the key at this point is 0, we
			// have a malformed key.
			//..............................................
			if (dwSizeOfKey == 0)
			{
				SetLastError(IDS_MALFORMEDCORRUPTKEYFILE);
				ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
				goto AddKeysEnd;
			}
			// If this is a public key we have to add a key trust
			// packet. If the key is marked as disabled, keep the
			// disabled bit set. There may, or may not, be a trust
			// packet after the key material.
			//....................................................
			if (TypeKey == PUBLIC_KEY)
			{
				__asm
				{
					mov		edi,lpKeyBufferDup3
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		TypePacket,al
				}
				if (TypePacket == CTB_TRUST)
				{
					GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup3
						add		edi,CTB_SIZE
						add		edi,edx
						mov		dwTempEAX,eax
						mov		lpKeyBufferDup3,edi
						sub		dwSizeOfKey,CTB_SIZE
						sub		dwSizeOfKey,edx
						sub		dwSizeOfKey,eax
					}
					if (*lpKeyBufferDup3 & DISABLED_BIT)
					{
						TrustPacket[2] |= DISABLED_BIT;
					}
				}
				CopyMemory(lpKeyBufferDup4,&TrustPacket,3);
				TrustPacket[2] = 0;
				lpKeyBufferDup4 += 3;
				dwSizeNewKey += 3;
				if (TypePacket == CTB_TRUST)
				{
					lpKeyBufferDup3 += dwTempEAX;
				}
			}
			// Process the rest of the key. Take it one packet at
			// a time and build the key to add to the key ring
			// in lpKeyBuffer4.
			//...................................................
			bHaveUserId = FALSE;
			bHaveCompSig = FALSE;

			while(TRUE)
			{
				if (dwSizeOfKey == 0)
				{
					break;
				}
				__asm
				{
					mov		edi,lpKeyBufferDup3
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		TypePacket,al
				}
				GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

				__asm
				{
					mov		dwTempEAX,eax
					mov		dwTempEDX,edx
				}
				if (TypePacket == CTB_USER_ID && dwTempEAX > MAX_USER_ID)
				{
					dwErrorCode = IDS_USERIDTOOBIG;
					goto SkipThisKey;
				}
				// Get and save the total length of this packet.
				//..............................................
				__asm
				{
					mov		eax,dwTempEAX
					add		eax,CTB_SIZE
					add		eax,dwTempEDX
					mov		dwPacketLength,eax
				}
				// The only packets we add to our key are user ids
				// and signatures.
				//.................................................
				if (TypeKey == SECRET_KEY && TypePacket == CTB_USER_ID)
				{
					CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,dwPacketLength);
					__asm
					{
						mov		eax,dwPacketLength
						add		lpKeyBufferDup4,eax
						add		lpKeyBufferDup3,eax
						sub		dwSizeOfKey,eax
						add		dwSizeNewKey,eax
					}
				}
				else if (TypeKey == PUBLIC_KEY && (TypePacket == CTB_USER_ID ||
					     TypePacket == CTB_SKE_PACKET))
				{
					if (TypePacket == CTB_USER_ID)
					{
						bHaveUserId = TRUE;
					}
					// Check out the signature packets to make sure
					// we can handle them.
					//.............................................
					if (TypePacket == CTB_SKE_PACKET)
					{
						__asm
						{
							mov		edi,lpKeyBufferDup3
							mov		cl,byte ptr [edi]
							mov		edx,1
							and		cl,LENGTH_MASK
							shl		edx,cl
							add		edi,CTB_SIZE
							add		edi,edx
							mov		lpTempEDI,edi
						}
						// If the wrong version we skip this sig.
						//.......................................
						if (*lpTempEDI != VERSION_OLD && *lpTempEDI != VERSION_NEW)
						{
							dwErrorCode = IDS_UNSUPPORTEDVERSIONSIG;

						  SkipSignature:
							SetLastError(dwErrorCode);
							ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
							lpKeyBufferDup3 += dwPacketLength;
							dwSizeOfKey -= dwPacketLength;
							continue;
						}
						lpTempEDI += VERSION_SIZE;
						if (*lpTempEDI != SKE_APPEND_LGTH && *lpTempEDI != SKE_SHA_APPEND_LGTH)
						{
							dwErrorCode = IDS_UNSUPPORTEDVERSIONSIG;
							goto SkipSignature;
						}
						lpTempEDI++;

						// If we do not have a user id and the first
						// signature is not a compromise signature
						// we skip this key.
						//..........................................
						if (!bHaveUserId && *lpTempEDI != KEY_COMPROMISE)
						{
							dwErrorCode = IDS_FIRSTSIGNOTCOMPROMISE;

						  SkipThisKey:
							SetLastError(dwErrorCode);
							ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
							bNewKeyAdded = FALSE;
							break;
						}
						// If compromise sig after user id or more
						// than 1 compromise sig.
						//........................................
						if (*lpTempEDI == KEY_COMPROMISE)
						{
							dwErrorCode = 0;

							if (bHaveCompSig)
							{
								dwErrorCode = IDS_MORETHANONECOMPROMISE;
							}
							else if (bHaveUserId)
							{
								dwErrorCode = IDS_COMPROMISEAFTERUSERID;
							}
							if (dwErrorCode)
							{
								goto SkipThisKey;
							}
						}
						// Check for invalid signature following a
						// user id.
						//........................................
						if (bHaveUserId && (*lpTempEDI < KEY_CERT_GEN ||
							*lpTempEDI > KEY_CERT_SELF))
						{
							dwErrorCode = IDS_UNKNOWNSIGNATURETYPE;
							goto SkipSignature;
						}
						// If no compromise sig yet and this is a
						// compromise sig, set bHaveCompSig to TRUE.
						//..........................................
						if (!bHaveCompSig)
						{
							if (*lpTempEDI == KEY_COMPROMISE)
							{
								bHaveCompSig = TRUE;
							}
						}
						lpTempEDI += (TIMESTAMP_SIZE + 1);
						lpTempEDI += KEY_ID_SIZE;

						__asm
						{
							mov		edi,lpTempEDI
							mov		al,byte ptr [edi]
							cmp		bConvertedFile,1
							je		L2
							and		al,0x01
						L2:	mov		TempByte,al
						}
						// If not RSA algorithm skip this key.
						//....................................
						if (TempByte != RSA_ALGORITHM)
						{
							dwErrorCode = IDS_NONRSAALGORITHMSIG;
							goto SkipSignature;
						}
						lpTempEDI += ALGORITHM_SIZE;

						// If not MD5, Sha1, or Sha512 message digest skip this sig.
						//..........................................................
						if (*lpTempEDI != MD5_ALGORITHM && *lpTempEDI != SHA_ALGORITHM &&
							*lpTempEDI != SHA512_ALGORITHM)
						{
							dwErrorCode = IDS_NONMD5ALGORITHMINSIG;
							goto SkipSignature;
						}
					}
					CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,dwPacketLength);

					__asm
					{
						mov		eax,dwPacketLength
						add		lpKeyBufferDup3,eax
						add		lpKeyBufferDup4,eax
						sub		dwSizeOfKey,eax
						add		dwSizeNewKey,eax
					}
					CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);
					__asm
					{
						mov		eax,TRUST_PCKT_SIZE
						add		lpKeyBufferDup4,eax
						add		dwSizeNewKey,eax
					}
				}
				else
				{
					// Skip trust and comment packets.
					//................................
					__asm
					{
						mov		eax,dwPacketLength
						add		lpKeyBufferDup3,eax
						sub		dwSizeOfKey,eax
					}
				}
			}	// while(TRUE)
		}
		// Write the new key to disk if we added a new key or
		// merged two keys with new stuff added.
		//...................................................
		if (bNewKeyAdded || (bKeysMerged && bNewStuffAdded))
		{
			li.QuadPart = 0;
			li.QuadPart = SetMyFilePointer(lpRingFile1,hKeyHandle1,li.QuadPart,FILE_END);
			if (li.QuadPart == -1)
			{
				goto AddKeysEnd;
			}
			bResult = WriteMyFile(lpRingFile1,hKeyHandle1,lpKeyBuffer4,dwSizeNewKey,
								  &dwBytesWritten,NULL);
			if (!bResult)
			{
				goto AddKeysEnd;
			}
			bKeysAdded = TRUE;
			bResult = FlushMyFile(lpRingFile1,hKeyHandle1);
			if (!bResult)
			{
				goto AddKeysEnd;
			}
		}
		// If we merged two keys with new stuff added we have to mark
		// the old key in the key ring for deletion. Key to be marked
		// is in lpKeyBuffer1.
		//...........................................................
		if (bKeysMerged && bNewStuffAdded)
		{
			bResult = MarkKey1(DELETE_IT);
			if (!bResult)
			{
				goto AddKeysEnd;
			}
		}
		// Reset the file pointer in our source file to point to
		// the next key.
		//......................................................
		li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,
									    liNextKey.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto AddKeysEnd;
		}
	}	// while(TRUE)

	Sleep(512);

	AddKeysEnd:

	EmptyTheMessageQue();

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if(hAddFromHandle)
	{
		CloseMyHandle((LPTSTR)&szKeyFile,hAddFromHandle);
		hAddFromHandle = 0;
	}
	if (bConvertedFile)
	{
		DeleteMyFile((LPTSTR)&szKeyFile);
		SwapOps((LPBYTE)&szKeyFile,(LPBYTE)&szDestination,MAX_PATH);
	}
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer3)
	{
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer3);
		lpKeyBuffer3 = 0;
	}
	if (lpKeyBuffer4)
	{
		ZeroMemory(lpKeyBuffer4,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer4);
		lpKeyBuffer4 = 0;
	}
	// Change the help topic back.
	//............................
	ChangeHelpTopic(dwOldHelpTopic);

	// See if we have to reindex and check the key rings.
	//...................................................
	if (bKeysAdded)
	{
		bResult = IndexKeyRingFiles(hMainWindow);
		if (!bResult)
		{
			goto AddEnd;
		}
		dwPublicDeleted = 0;
		dwSecretDeleted = 0;

		// Perform checks on the key rings.
		//.................................
		bResult = CheckOutTheKeyRings(TRUE,hMainWindow);
		if (!bResult)
		{
			goto AddEnd;
		}
		if (bKeysAdded)
		{
			bBackupFiles = TRUE;
			bKeysAdded = FALSE;
		}
	}
	else
	{
		if (bProcessedKeyFile)
		{
			if (TypeKey == SECRET_KEY)
			{
				uiMessage = IDS_NONEWSECADDED;
			}
			else
			{
				uiMessage = IDS_NONEWPUBADDED;
			}
			LoadString(hInst,uiMessage,(LPTSTR)&szStatement,sizeof(szStatement));
			StringCbPrintf((LPTSTR)szOutBuff,sizeof(szOutBuff),TEXT("Key File: %s \n\n%s"),
							szKeyFile,szStatement);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szOutBuff,
				           MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		}
	}
	AddEnd:

	if (dwSource == SELECT_SOURCE)
	{
		bProcessInProgress = FALSE;
	}
}

// Check out the file to see if it has any new version packets
// or needs to be converted from V4 to V3 keys. Returns 0 for
// no error, error number, or -1 for error already displayed.
//............................................................
BOOL CheckOutTheFile()
{
	LARGE_INTEGER		li;
	BOOL				bError = TRUE;
	TCHAR				szTempPath[MAX_PATH];
	HANDLE				hNewFile = 0;
	DWORD				dwBytesRead;
	DWORD				dwBytesToRead;
	DWORD				dwBytesWritten;
	BOOL				bResult;
	DWORD				dwCtb_Byte;
	BYTE				TempCTB;
	BYTE				TempByte;
	BOOL				bConvert = FALSE;
	DWORD				dwLengthOfLengthField;
	DWORD				dwLengthField;
	DWORD				dwSizeNewKey;
	BOOL				bVersion4;

	liNextKey.QuadPart = 0;

	// Rewind the file to add from.
	//.............................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto ConvertEnd;
	}
	// Loop through the file to see if we have to convert it or not.
	//..............................................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		bResult = ReadMyFile((LPTSTR)&szKeyFile,hAddFromHandle,lpKeyBuffer3,1,&dwBytesRead,
							  NULL);
		if (!bResult)
		{
			goto ConvertEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Get the first byte of the key, the CTB byte and see if it is a new
		// format packet which we do not support.
		//...................................................................
		__asm
		{
			mov		edi,lpKeyBuffer3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			mov		TempByte,al
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempByte & 0x40)
		{
			SetLastError(IDS_DONOTSUPPORTNEWVERSIONFORMAT);
			ErrorProcedure((LPTSTR)&szKeyFile,IDS_ADDKEYPROC,MB_OK);
			goto ConvertEnd;
		}
		// Not a new format key. Get the length of the length field.
		//..........................................................
		__asm
		{
			mov		cl,TempByte
			mov		edx,1
			and		cl,LENGTH_MASK
			shl		edx,cl
			cmp		cl,NO_LENGTH
			je		BadFile
			mov		dwBytesToRead,edx
		}
		bResult = ReadMyFile((LPTSTR)&szKeyFile,hAddFromHandle,lpKeyBuffer3,dwBytesToRead,
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto ConvertEnd;
		}
		if (dwBytesToRead != dwBytesRead)
		{
		  BadFile:
			SetLastError(IDS_MALFORMEDCORRUPTKEYFILE);
			ErrorProcedure((LPTSTR)&szKeyFile,IDS_ADDKEYPROC,MB_OK);
			goto ConvertEnd;
		}
		GetPcktLgth(lpKeyBuffer3,dwBytesRead);

		__asm
		{
			mov		dwBytesToRead,eax
		}
		// Read in the whole packet.
		//..........................
		bResult = ReadMyFile((LPTSTR)&szKeyFile,hAddFromHandle,lpKeyBuffer3,dwBytesToRead,
							 &dwBytesRead,NULL);
		if(!bResult)
		{
			goto ConvertEnd;
		}
		if (dwBytesToRead != dwBytesRead)
		{
			goto BadFile;
		}
		// If this is a version 4 key we have to convert. Only check version for
		// public, secret, and sig packets.
		//......................................................................
		if (TempCTB == CTB_SECRET_KEY || TempCTB == CTB_PUBLIC_KEY || TempCTB == CTB_SKE_PACKET)
		{
			if (*lpKeyBuffer3 != VERSION_OLD && *lpKeyBuffer3 != VERSION_NEW)
			{
				if (*lpKeyBuffer3 == VERSION_4_KEY)
				{
					bConvert = TRUE;
				}
			}
		}
	}
	// If we do not have to convert, return with no errors.
	//.....................................................
	if(!bConvert)
	{
		bError = FALSE;
		goto ConvertEnd;
	}
	// Rewind the file to convert.
	//............................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto ConvertEnd;
	}
	// Create a temporary file to hold the converted file.
	//....................................................
	GetTempPath(MAX_PATH,(LPTSTR)&szTempPath);
	GetTempFileName((LPTSTR)&szTempPath,TEXT("idx"),0,(LPTSTR)&szDestination);
	hNewFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,NULL,
							 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hNewFile)
	{
		goto ConvertEnd;
	}
	// Go into a loop and process the file.
	//.....................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		lpKeyBufferDup3 = lpKeyBuffer3;
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		bResult = ReadMyFile((LPTSTR)&szKeyFile,hAddFromHandle,lpKeyBuffer3,
							  SIZE_KEY_BUFF,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ConvertEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Determine the size of the whole key, including user ids,
		// trust packets, and signatures.
		//.........................................................
		dwSizeOfKey = FindTheNextKey();
		if (dwSizeOfKey == 0)
		{
			goto ConvertEnd;
		}
		// Now flush the read buffer and read in only the length
		// of this key. Makes it easier when transferring the key
		// to a buffer.
		//.......................................................
		li.QuadPart = SetMyFilePointer((LPTSTR)&szKeyFile,hAddFromHandle,
										liNextKey.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto ConvertEnd;
		}
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		bResult = ReadMyFile((LPTSTR)&szKeyFile,hAddFromHandle,
							  lpKeyBuffer3,dwSizeOfKey,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ConvertEnd;
		}
		liNextKey.LowPart += dwSizeOfKey;

		lpKeyBufferDup4 = lpKeyBuffer4;
		dwSizeNewKey = 0;

		// Go into a loop and convert this key. We transfer everything except
		// version 4 signatures and secret subkey packets. Change version 4
		// public and secret key packets to version 3 and add a validity period.
		//......................................................................
		while(TRUE)
		{
			// Check for end of packet.
			//.........................
			if (*lpKeyBufferDup3 == 0)
			{
				break;
			}
			__asm
			{
				mov		esi,lpKeyBufferDup3
				lodsb
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		TempCTB,al
			}
			// Get the packet length and length of the length field.
			// When put back bswap into correct order.
			//......................................................
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				inc		lpKeyBufferDup3
				mov		dwLengthField,eax
				mov		dwLengthOfLengthField,edx
			}
			if (TempCTB == CTB_SECRET_KEY || TempCTB == CTB_PUBLIC_KEY)
			{
				// We have to check for version 4 and add a validity field.
				//.........................................................
				__asm
				{
					mov		bVersion4,0
					mov		esi,lpKeyBufferDup3
					add		esi,dwLengthOfLengthField
					cmp		byte ptr [esi],4
					jne		L1
					mov		bVersion4,1
				}
				L1:

				if (bVersion4)
				{
					// Change the version to version 3 and add a validity field.
					// Add two to the length of the packet.
					//..........................................................
					__asm
					{
						mov		edi,lpKeyBufferDup3
						push	edi
						mov		eax,dwLengthField
						add		eax,VALIDITY_SIZE
						cmp		dwLengthOfLengthField,1
						jne		L3
						stosb
						jmp		L5
					L3:	cmp		dwLengthOfLengthField,2
						jne		L4
						xchg	ah,al
						stosw
						jmp		L5
					L4:	bswap	eax
						stosd
					L5:	pop		edi
						add		edi,dwLengthOfLengthField
						mov		byte ptr [edi],3

						// We have to move everything up to where the validity field
						// should be.
						//..........................................................
						mov		esi,lpKeyBufferDup3
						mov		edi,lpKeyBufferDup4
						mov		eax,dwCtb_Byte
						stosb
						inc		dwSizeNewKey
						mov		ecx,dwLengthOfLengthField
						add		ecx,(VERSION_SIZE + TIMESTAMP_SIZE)
						add		dwSizeNewKey,ecx
						rep		movsb

						// Add in the validity field.
						//...........................
						xor		eax,eax
						stosw
						add		dwSizeNewKey,VALIDITY_SIZE

						// Now transfer the rest of the packet.
						//.....................................
						mov		ecx,dwLengthField
						sub		ecx,(VERSION_SIZE + TIMESTAMP_SIZE)
						add		dwSizeNewKey,ecx
						rep		movsb
						mov		lpKeyBufferDup3,esi
						mov		lpKeyBufferDup4,edi
					}
				}
				else
				{
					// Version 3 key.
					//...............
					__asm
					{
						mov		esi,lpKeyBufferDup3
						mov		edi,lpKeyBufferDup4
						mov		eax,dwCtb_Byte
						stosb
						inc		dwSizeNewKey
						mov		ecx,dwLengthOfLengthField
						add		ecx,dwLengthField
						add		dwSizeNewKey,ecx
						rep		movsb
						mov		lpKeyBufferDup3,esi
						mov		lpKeyBufferDup4,edi
					}
				}
			}
			else if (TempCTB == CTB_SKE_PACKET)
			{
				// We have a signature packet. Skip version 4 sigs.
				//.................................................
				__asm
				{
					mov		bVersion4,0
					mov		esi,lpKeyBufferDup3
					add		esi,dwLengthOfLengthField
					cmp		byte ptr [esi],4
					jne		L2
					mov		bVersion4,1
				}
				L2:

				if (bVersion4)
				{
					__asm
					{
						mov		edi,lpKeyBufferDup3
						add		edi,dwLengthOfLengthField
						add		edi,dwLengthField
						mov		lpKeyBufferDup3,edi
					}
				}
				else
				{
					__asm
					{
						mov		esi,lpKeyBufferDup3
						mov		edi,lpKeyBufferDup4
						mov		eax,dwCtb_Byte
						stosb
						inc		dwSizeNewKey
						mov		ecx,dwLengthOfLengthField
						add		ecx,dwLengthField
						add		dwSizeNewKey,ecx
						rep		movsb
						mov		lpKeyBufferDup3,esi
						mov		lpKeyBufferDup4,edi
					}
				}
			}
			else if (TempCTB == CTB_USER_ID)
			{
				__asm
				{
					mov		esi,lpKeyBufferDup3
					mov		edi,lpKeyBufferDup4
					mov		eax,dwCtb_Byte
					stosb
					inc		dwSizeNewKey
					mov		ecx,dwLengthOfLengthField
					add		ecx,dwLengthField
					add		dwSizeNewKey,ecx
					rep		movsb
					mov		lpKeyBufferDup3,esi
					mov		lpKeyBufferDup4,edi
				}
			}
			else
			{
				// We skip all other packets.
				//...........................
				__asm
				{
					mov		edi,lpKeyBufferDup3
					add		edi,dwLengthOfLengthField
					add		edi,dwLengthField
					mov		lpKeyBufferDup3,edi
				}
			}
		}
		// Write the new key to disk.
		//...........................
		bResult = WriteMyFile((LPTSTR)&szDestination,hNewFile,lpKeyBuffer4,dwSizeNewKey,
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto ConvertEnd;
		}
	}
	// We have successfully converted the file.
	//.........................................
	bResult = CloseMyHandle((LPTSTR)&szKeyFile,hAddFromHandle);
	if (!bResult)
	{
		goto ConvertEnd;
	}
	hAddFromHandle = 0;

	bResult = CloseMyHandle((LPTSTR)&szDestination,hNewFile);
	if (!bResult)
	{
		goto ConvertEnd;
	}
	hNewFile = 0;

	SwapOps((LPBYTE)&szKeyFile,(LPBYTE)&szDestination,MAX_PATH);
	bConvertedFile = TRUE;

	// Open the converted key file.
	//.............................
	hAddFromHandle = CreateMyFile((LPTSTR)&szKeyFile,GENERIC_READ,0,NULL,OPEN_EXISTING,
								   FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hAddFromHandle)
	{
		goto ConvertEnd;
	}
	bError = FALSE;
	
	ConvertEnd:

	if (hNewFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hNewFile);

		// If we had errors and we did not finish conversion, delete the file.
		//....................................................................
		if (bError && !bConvertedFile)
		{
			DeleteMyFile((LPTSTR)&szDestination);
		}
	}
	return(bError);
}

// Dialog box to display while adding keys to a key ring.
//.......................................................
LRESULT CALLBACK AddKeysToKeyRingProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the from file name.
			//........................
			SetDlgItemTextFmt(hDlg,IDC_KEYSFROM,(LPCTSTR)&szKeyFile);

			// Set the name of the key ring file.
			//...................................
			SetDlgItemTextFmt(hDlg,IDC_KEYSTO,lpRingFile1);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		case WM_CLOSE:
		{
			break;
		}

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Find the start of the next key and in the process determine
// the length of this one. Returns 0 if error in key format,
// or else it returns the length of the key. Start of key in
// lpKeyBuffer3.
//............................................................
DWORD FindTheNextKey()
{
	DWORD		dwLengthOfKey;
	DWORD		dwLengthFieldSize;
	DWORD		dwPacketLength;
	BOOL		bResult;
	BYTE		KeyType;
	BYTE		CTBByte;
	BYTE		TempCL;

	KeyType = 0;
	dwLengthOfKey = 0;
	lpKeyBufferDup3 = lpKeyBuffer3;
	bSkipKey = FALSE;

	while(TRUE)
	{
		// Check for the end of the last packet in the source file.
		//.........................................................
		if (*lpKeyBufferDup3 == 0)
		{
			goto FindEnd;
		}
		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		TempCL,cl
			and		al,CTB_MASK
			mov		CTBByte,al
		}
		bResult = IsValidCTB(KeyType,CTBByte);
		if (!bResult)
		{
			dwLengthOfKey = 0;
			goto FindEnd;
		}
		// We need a valid public or secret key here. If not
		// we have an invalid file. First byte has to be a
		// public or secret key type. Only entered on the
		// first byte of a key.
		//..................................................
		if (!KeyType)
		{
			if (CTBByte != CTB_SECRET_KEY && CTBByte != CTB_PUBLIC_KEY)
			{
				SetLastError(IDS_NOTPUBSECCTB);
				ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
				dwLengthOfKey = 0;
				goto FindEnd;
			}
			KeyType = CTBByte;
			CTBByte = 0;
		}
		// If we got here, check to see if we are at the end of
		// this key. dwLengthOfKey is the size of the key.
		//.....................................................
		if (KeyType == CTBByte)
		{
			goto FindEnd;
		}
		// Check out the size of the length field.
		//........................................
		__asm
		{
			mov		edx,1
			mov		cl,TempCL
			and		cl,LENGTH_MASK
			shl		edx,cl
			mov		TempCL,cl
			mov		dwLengthFieldSize,edx
		}
		if (TempCL >= LENGTH_4)
		{
			SetLastError(IDS_INVALIDLENGTHFIELDSIZE);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			dwLengthOfKey = 0;
			goto FindEnd;
		}
		// Update total length and internal pointer.
		//..........................................
		dwLengthOfKey += CTB_SIZE;
		lpKeyBufferDup3 += CTB_SIZE;
		GetPcktLgth(lpKeyBufferDup3,dwLengthFieldSize);

		__asm
		{
			mov		dwPacketLength,eax
		}
		if (dwPacketLength == 0)
		{
			SetLastError(IDS_PACKETSIZEEQUALSZERO);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			dwLengthOfKey = 0;
			goto FindEnd;
		}
		dwLengthOfKey += dwLengthFieldSize;
		dwLengthOfKey += dwPacketLength;
		lpKeyBufferDup3 += dwLengthFieldSize;
		lpKeyBufferDup3 += dwPacketLength;
		if (dwLengthOfKey > SIZE_KEY_BUFF)
		{
			SetLastError(IDS_KEYTOOLARGE);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			dwLengthOfKey = 0;
			goto FindEnd;
		}
		// See if the key packet length is too big.
		//.........................................
		dwPacketLength += 3;
		if (KeyType == CTB_SECRET_KEY && 
			dwPacketLength > MAX_SECKEY_SIZE)
		{
			SetLastError(IDS_KEYPACKETTOOLARGE);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			bSkipKey = TRUE;
		}
		else if (KeyType == CTB_PUBLIC_KEY && dwPacketLength > MAX_PUBKEY_SIZE)
		{
			SetLastError(IDS_KEYPACKETTOOLARGE);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
			bSkipKey = TRUE;
		}
	}

	FindEnd:

	lpKeyBufferDup3 = lpKeyBuffer3;
	return(dwLengthOfKey);
}

// Check out a CTB to make sure it is a valid one for adding
// to a key ring. Returns TRUE if valid, else FALSE.
//..........................................................
BOOL IsValidCTB(BYTE KeyType, BYTE CTBByte)
{
	BOOL		bResult = TRUE;

	// Only check the CTBs if we have a defined key type.
	//...................................................
	if (KeyType)
	{
		if (KeyType == CTB_SECRET_KEY)
		{
			if (CTBByte != CTB_USER_ID && CTBByte != CTB_SECRET_KEY &&
				CTBByte != CTB_COMMENT && CTBByte != CTB_SECRET_SUB_PCK && 
				CTBByte != CTB_TRUST && CTBByte != CTB_SKE_PACKET)
			{
				bResult = FALSE;
			}
		}
		else
		{
			if (CTBByte != CTB_PUBLIC_KEY && CTBByte != CTB_USER_ID &&
				CTBByte != CTB_SKE_PACKET && CTBByte != CTB_TRUST &&
				CTBByte != CTB_COMMENT)
			{
				bResult = FALSE;
			}
		}
	}
	if (!bResult)
	{
		SetLastError(IDS_UNKNOWNCTBBYTE);
		ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
	}
	return(bResult);
}

// MergeTheKeys checks to see if two keys with the same key id
// are different and if so, merges the information from the two
// keys into one key and adds it to the key ring. The original
// key is then marked for deletion.
//
// Entry: Key from key ring in lpKeyBuffer1.
//        Key from source file in lpKeyBuffer3.
//        Merge the keys into lpKeyBuffer4.
//
// Returns: FALSE if unrecoverable error.
//          If the two keys are different mark the original
//          for deletion, and write the new merged key to
//          the end of the key ring. If they are the same
//          we skip this key and return.
//.............................................................
BOOL MergeTheKeys()
{
	BOOL		bResult;
	LPBYTE		lpN3Ptr;
	DWORD		dwN3PcktLength;
	DWORD		dwSearchSize;
	BOOL		bHaveOldComp;
	BOOL		bHaveNewComp;
	DWORD		dwCtb_Byte;
	DWORD		dwTempEAX;
	DWORD		dwTempEAX1;
	LPBYTE		lpTempEDI;
	LPBYTE		lpTempEDI1;
	BYTE		TempCTB;
	BYTE		TempTrustByte;

	bHaveOldComp = FALSE;
	bHaveNewComp = FALSE;
	bResult = FALSE;

	__asm
	{
		mov		eax,lpKeyBuffer1
		mov		lpKeyBufferDup1,eax
		mov		lpN1Ptr,eax
		mov		lpNextUserId,eax
	}
	// Setup pointer to modulus n is source buffer.
	//.............................................
	lpN3Ptr = lpN3Offset;

	// Find modulus n in lpKeyBuffer1.
	//................................
	__asm
	{
		mov		edi,lpN1Ptr
		mov		al,byte ptr [edi]
		mov		cl,al
		mov		dwCtb_Byte,ecx
		and		al,CTB_MASK
		mov		TempCTB,al
	}
	if (TempCTB != CTB_SECRET_KEY && TempCTB != CTB_PUBLIC_KEY)
	{
		
		SetLastError(IDS_MALFORMEDCORRUPTKEYINSOURCE);
		ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
		goto MergeEnd;
	}
	GetPcktLength(lpN1Ptr,dwCtb_Byte);

	__asm
	{
		add		eax,edx
		add		eax,CTB_SIZE
		mov		dwN1PcktLength,eax
		mov		edi,lpN1Ptr
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,(VERSION_SIZE + TIMESTAMP_SIZE + VALIDITY_SIZE + ALGORITHM_SIZE)
		movzx	eax,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		mov		lpN1Ptr,edi
		xchg	ah,al
		add		eax,7
		shr		eax,3
		mov		dwTempEAX,eax
	}
	if (dwTempEAX != dwN3Bytes)
	{
	  KeysDifferent:
		SetLastError(IDS_MATCHINGKEYIDSINDIFFERENTKEYS);
		ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
		bResult = TRUE;
		goto MergeEnd;
	}
	// Modulus n should be the same in both keys.
	//...........................................
	__asm
	{
		mov		edi,lpN1Ptr
		mov		esi,lpN3Ptr
		mov		ecx,dwN3Bytes
		repe	cmpsb
		jnz		KeysDifferent

		// If the source key packet length is not the same as
		// the one on our key ring it could be corrupt.
		//...................................................
		mov		eax,dwPacketLength
		cmp		eax,dwN1PcktLength
		jne		KeysDifferent
	}
	// Move this packet to lpKeyBuffer4 where we will build the new key.
	//..................................................................
	lpKeyBufferDup4 = lpKeyBuffer4;
	CopyMemory(lpKeyBufferDup4,lpKeyBufferDup1,dwN1PcktLength);

	__asm
	{
		mov		eax,dwPacketLength
		add		lpKeyBufferDup4,eax
		add		lpKeyBufferDup3,eax
		add		lpKeyBufferDup1,eax
		sub		dwSizeOfKey,eax
		mov		dwSizeNewKey,eax
	}
	// If the size of the key at this point is 0, we have a
	// malformed key. Cancel merging since we have nothing to merge.
	//..............................................................
	if (dwSizeOfKey == 0)
	{
		SetLastError(IDS_MALFORMEDCORRUPTKEYNOMERGE);
		ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
		goto MergeEnd;
	}
	// If this is a public key we have to add a key trust packet.
	// If the old key is disabled, leave it that way.
	//...........................................................
	if (TypeKey == PUBLIC_KEY)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
			mov		TempTrustByte,0
		}
		if (TempCTB == CTB_TRUST)
		{
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup3
				add		edi,CTB_SIZE
				add		edi,edx
				mov		bl,byte ptr [edi]
				and		bl,DISABLED_BIT
				mov		TempTrustByte,bl
			}
		}
		__asm
		{
			mov		edi,lpKeyBufferDup1
			and		byte ptr [edi+2],DISABLED_BIT
			mov		bl,TempTrustByte
			or		byte ptr [edi+2],bl
		}
		CopyMemory(lpKeyBufferDup4,lpKeyBufferDup1,TRUST_PCKT_SIZE);

		__asm
		{
			mov		eax,TRUST_PCKT_SIZE
			add		lpKeyBufferDup4,eax
			add		lpKeyBufferDup1,eax
			add		dwSizeNewKey,eax
			
			// Start of first user id in old key.
			//...................................
			mov		edi,lpKeyBufferDup1
			mov		lpN1Ptr,edi

			// Check our key ring for a compromise certificate.
			// This has to be placed right after the trust packet
			// for the key. If there is a signature right after
			// the key trust byte on our key ring we assume it is
			// a good compromise sig.
			//...................................................
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempCTB == CTB_SKE_PACKET)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				add		eax,edx
				add		eax,CTB_SIZE
				mov		dwN1PcktLength,eax
				mov		bHaveOldComp,TRUE
			}
		}
		// Let's check the new key to see if it has a compromise
		// certificate. If it does and it is the same we will skip
		// it. If not the same, something is not quit right.
		//........................................................
		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		// If we have a trust packet after the key packet we have
		// to skip its size because we already added our own.
		//.......................................................
		if (TempCTB == CTB_TRUST)
		{
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup3
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup3,edi
				sub		dwSizeOfKey,CTB_SIZE
				sub		dwSizeOfKey,edx
				sub		dwSizeOfKey,eax
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		TempCTB,al
			}
		}
		if (TempCTB == CTB_SKE_PACKET)
		{
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup3
				add		edi,CTB_SIZE
				add		eax,edx
				add		eax,CTB_SIZE
				mov		dwN3PcktLength,eax
				add		edi,edx

				// Get past the version byte and length of following
				// material byte.
				//..................................................
				add		edi,2
				mov		lpTempEDI,edi
			}
			// If not a key compromise certificate skip this key
			// because something is not right. Sig right after
			// key must be compromise sig. Or we may have a 
			// signature that is formated differently.
			//..................................................
			if (*lpTempEDI != KEY_COMPROMISE)
			{
				SetLastError(IDS_FIRSTSIGNOTCOMPROMISENOMERGE);
				ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
				bResult = TRUE;
				goto MergeEnd;
			}
			bHaveNewComp = TRUE;

			// If the old and new comp sigs do not match,
			// something smells.
			//...........................................
			if (bHaveOldComp && dwN3PcktLength != dwN1PcktLength)
			{
			  CompsNoMatch:
				SetLastError(IDS_COMPSIGSNOMATCH);
				ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
				bResult = TRUE;
				goto MergeEnd;
			}
			else
			{
				dwN1PcktLength = dwN3PcktLength;
			}
			// Compare the compromise certificates.
			//.....................................
			if (bHaveOldComp)
			{
				__asm
				{
					mov		edi,lpKeyBufferDup1
					mov		esi,lpKeyBufferDup3
					mov		ecx,dwN1PcktLength
					repe	cmpsb
					jnz		CompsNoMatch
				}
			}
		}
		// Transfer whichever comp sig we have. If present on both
		// keys used the old one. If not, use the new and mark that
		// we have added new material to the key.
		//.........................................................
		if (bHaveOldComp)
		{
			CopyMemory(lpKeyBufferDup4,lpKeyBufferDup1,dwN1PcktLength);
			__asm
			{
				mov		eax,dwN1PcktLength
				add		lpKeyBufferDup4,eax
				add		lpKeyBufferDup1,eax
				add		dwSizeNewKey,eax
			}
			if (bHaveNewComp)
			{
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup3,eax
				}
			}
			// Put start of first user id in old file in lpN1Ptr.
			//...................................................
			__asm
			{
				mov		eax,lpKeyBufferDup1
				mov		lpN1Ptr,eax
			}
		}
		else if (bHaveNewComp)
		{
			CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,dwN1PcktLength);

			__asm
			{
				mov		eax,dwN1PcktLength
				add		lpKeyBufferDup4,eax
				add		lpKeyBufferDup3,eax
				add		dwSizeNewKey,eax
				mov		bNewStuffAdded,TRUE
			}
		}
	}	// if (TypKey == PUBLIC_KEY)

	// Now we can process the rest of the key. Do the secret key
	// ring first.
	//..........................................................
	__asm
	{
		mov		eax,dwRecordLength1
		mov		ecx,lpKeyBufferDup3
		sub		ecx,lpKeyBuffer3
		sub		eax,ecx
		mov		dwSearchSize,eax
	}
	if (TypeKey == SECRET_KEY)
	{
		// Set lpN1Ptr to point to the first user id in the secret key.
		//.............................................................
		lpN1Ptr = lpKeyBufferDup1;

		// Transfer all the old user ids to the new key.
		//..............................................
		CopyMemory(lpKeyBufferDup4,lpKeyBufferDup1,dwSearchSize);

		__asm
		{
			mov		eax,dwSearchSize
			add		dwSizeNewKey,eax
		}
		while(TRUE)
		{
			// End of material for this key?
			//..............................
			if (*lpKeyBufferDup3 == 0)
			{
				break;
			}
			__asm
			{
				mov		edi,lpKeyBufferDup3
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		TempCTB,al
			}
			if (TempCTB != CTB_USER_ID)
			{
				if (TempCTB == CTB_COMMENT)
				{
					GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup3
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpKeyBufferDup3,edi
					}
					continue;
				}
				else
				{
					SetLastError(IDS_EXPECETEDUSERIDINSECRETKEY);
					ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
					bNewStuffAdded = FALSE;
					bResult = TRUE;
					goto MergeEnd;
				}
			}
			// We have a user id.
			//...................
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup3
				add		edi,CTB_SIZE
				push	eax
				add		edi,edx
				add		eax,CTB_SIZE
				add		eax,edx
				mov		dwN1PcktLength,eax
				pop		eax
				mov		dwTempEAX,eax
				mov		lpTempEDI,edi
			}
			// If the user id is too large we skip it.
			//........................................
			if (dwTempEAX > MAX_USER_ID)
			{
				SetLastError(IDS_USERIDTOBIGSKIP);
				ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);

				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup3,eax
				}
				continue;
			}

			bResult = FALSE;

			// Look for a matching user id in the old file.
			// Only have user ids in the secret key.
			//.............................................
			while(TRUE)
			{
				// End of the key and no matching user id.
				//........................................
				if (*lpN1Ptr == 0)
				{
					break;
				}
				__asm
				{
					mov		edi,lpN1Ptr
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		TempCTB,al
				}
				if (TempCTB != CTB_USER_ID)
				{
					GetPcktLength(lpN1Ptr,dwCtb_Byte);

					__asm
					{
						mov		edi,lpN1Ptr
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpN1Ptr,edi
					}
				}
				else
				{
					// We have a user id.
					//...................
					GetPcktLength(lpN1Ptr,dwCtb_Byte);

					_asm
					{
						mov		edi,lpN1Ptr
						add		edi,CTB_SIZE
						add		edi,edx
						mov		lpTempEDI1,edi
						mov		dwTempEAX1,eax
						add		edi,eax
						mov		lpN1Ptr,edi		// Next packet or eof.
					}
					if (dwTempEAX1 != dwTempEAX)
					{
						continue;
					}
					// The user ids are equal length, compare them.
					//.............................................
					__asm
					{
						mov		esi,lpTempEDI
						mov		edi,lpTempEDI1
						mov		ecx,dwTempEAX
						repe	cmpsb
						jne		L1
						mov		bResult,TRUE
					  L1:
					}
				}
				if (bResult)
				{
					// We have an exact match.
					//.......................
					break;
				}
			}
			// Reset lpN1Ptr.
			//...............
			lpN1Ptr = lpKeyBufferDup1;

			// We have a match. Do not transfer this user id since
			// it was in the old key ring.
			//.....................................................
			if (bResult)
			{
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup3,eax
				}
			}
			else
			{
				// No match means new user id. Transfer it to
				// lpKeyBufferDup4.
				//...........................................
				CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,
					       dwN1PcktLength);
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup3,eax
					add		lpKeyBufferDup4,eax
					add		dwSizeNewKey,eax
					mov		bNewStuffAdded,TRUE
				}
			}
		}	// while(TRUE)

		bResult = TRUE;
		goto MergeEnd;
	}
	// Type of key is public key. It gets hard from here.
	// First packet has to be a user id or else we have
	// a key without one. If so, skip it.
	//...................................................
	__asm
	{
		mov		edi,lpKeyBufferDup3
		mov		al,byte ptr [edi]
		and		al,CTB_MASK
		mov		TempCTB,al
	}
	if (TempCTB != CTB_USER_ID)
	{
		SetLastError(IDS_USERIDREQUIRED);
		ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
		bNewStuffAdded = FALSE;
		bResult = TRUE;
		goto MergeEnd;
	}
	// Check out the public key.
	//..........................
	while(TRUE)
	{
		// End of this key?
		//.................
		if (*lpKeyBufferDup3 == 0)
		{
			break;
		}
		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		// Skip the trust packets. We add our own where needed.
		//.....................................................
		if (TempCTB == CTB_TRUST)
		{
			lpKeyBufferDup3 += TRUST_PCKT_SIZE;
			continue;
		}
		else if (TempCTB == CTB_USER_ID)
		{
			// See if the user id in the source file is already
			// in the key.
			//.................................................
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup3
				add		edi,CTB_SIZE
				push	eax
				add		edi,edx
				add		eax,edx
				add		eax,CTB_SIZE
				mov		dwN1PcktLength,eax
				pop		eax
				mov		dwTempEAX,eax
				mov		lpTempEDI,edi
			}
			// If the user id is too big we will skip it.
			//...........................................
			if (dwTempEAX > MAX_USER_ID)
			{
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup3,eax
				}
				continue;
			}
			bResult = FALSE;
			lpN1Ptr = lpKeyBufferDup1;	// First user id in old key.

			while(TRUE)
			{
				// End of the key and no matching user id.
				//........................................
				if (*lpN1Ptr == 0)
				{
					break;
				}
				__asm
				{
					mov		edi,lpN1Ptr
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		TempCTB,al
				}
				if (TempCTB != CTB_USER_ID)
				{
					GetPcktLength(lpN1Ptr,dwCtb_Byte);

					__asm
					{
						mov		edi,lpN1Ptr
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpN1Ptr,edi
					}
				}
				else
				{
					// We have a user id.
					//...................
					GetPcktLength(lpN1Ptr,dwCtb_Byte);

					_asm
					{
						mov		edi,lpN1Ptr
						add		edi,CTB_SIZE
						add		edi,edx
						mov		lpTempEDI1,edi
						mov		dwTempEAX1,eax
						add		edi,eax
						mov		lpN1Ptr,edi		// Next packet or eof.
					}
					if (dwTempEAX1 != dwTempEAX)
					{
						continue;
					}
					// The user ids are equal length, compare them.
					//.............................................
					__asm
					{
						mov		esi,lpTempEDI
						mov		edi,lpTempEDI1
						mov		ecx,dwTempEAX
						repe	cmpsb
						jne		L2
						mov		bResult,TRUE
					  L2:
					}
				}
				if (bResult)
				{
					// We have an exact match.
					//.......................
					break;
				}
			}
			// If we have a match transfer the new one to the buffer
			// and mark the old one for no transfer.
			//......................................................
			if (bResult)
			{
				// Have the lpN1Ptr point to the first sig after the
				// user id in the old key, or the end of the key,
				// which matches the source user id.
				//..................................................
				__asm
				{
					mov		edi,lpN1Ptr
					add		lpN1Ptr,TRUST_PCKT_SIZE
					sub		edi,dwN1PcktLength
					or		byte ptr [edi],NO_COPY_BIT
				}
				// We need to find the next user id offset in the
				// old key ring. Helps when looking at sigs.
				//...............................................
				lpNextUserId = lpN1Ptr;
				while(TRUE)
				{
					if (*lpNextUserId == 0)
					{
						break;
					}
					__asm
					{
						mov		edi,lpNextUserId
						mov		al,byte ptr [edi]
						mov		cl,al
						mov		dwCtb_Byte,ecx
						and		al,CTB_MASK
						mov		TempCTB,al
					}
					// We have found the next user id.
					//................................
					if (TempCTB == CTB_USER_ID)
					{
						break;
					}
					GetPcktLength(lpNextUserId,dwCtb_Byte);

					__asm
					{
						mov		edi,lpNextUserId
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpNextUserId,edi
					}
				}	// while(TRUE)

				// Transfer the user id to lpKeyBufferDup4.
				//.........................................
				CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,dwN1PcktLength);
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup3,eax
					add		lpKeyBufferDup4,eax
					add		dwSizeNewKey,eax
				}
				// Add our trust packet for this user id to the
				// new key.
				//.............................................
				CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);

				__asm
				{
					add		lpKeyBufferDup4,TRUST_PCKT_SIZE
					add		dwSizeNewKey,TRUST_PCKT_SIZE
				}
				// Merge the signatures for this user id. Exit with
				// lpKeyBufferDup3 pointing to the next user id or
				// the end of the key.
				//.................................................
				MergeSignatures();
			}
			else
			{
				// No matching user id. Transfer this new user id and
				// and signatures. When done lpKeyBufferDup3 points
				// to the next user id, or the end of the key.
				//...................................................
				CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,dwN1PcktLength);
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup3,eax
					add		lpKeyBufferDup4,eax
					add		dwSizeNewKey,eax
					mov		bNewStuffAdded,TRUE
				}
				// Add a trust packet to the user id.
				//...................................
				CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);

				__asm
				{
					add		lpKeyBufferDup4,TRUST_PCKT_SIZE
					add		dwSizeNewKey,TRUST_PCKT_SIZE
				}
				// Now add any signatures for this user id.
				//.........................................
				while(TRUE)
				{	
					// Check for end of the public key.
					//.................................
					if (*lpKeyBufferDup3 == 0)
					{
						goto EndOfPublicKey;
					}
					__asm
					{
						mov		edi,lpKeyBufferDup3
						mov		al,byte ptr [edi]
						mov		cl,al
						mov		dwCtb_Byte,ecx
						and		al,CTB_MASK
						mov		TempCTB,al
					}
					// If we have the next user id break out
					// of the loop.
					//......................................
					if (TempCTB == CTB_USER_ID)
					{
						break;
					}
					// Skip all packets except the signatures.
					//........................................
					if (TempCTB != CTB_SKE_PACKET)
					{
						GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

						__asm
						{
							mov		edi,lpKeyBufferDup3
							add		edi,CTB_SIZE
							add		edi,edx
							add		edi,eax
							mov		lpKeyBufferDup3,edi
						}
					}
					else
					{
						// We have a signature packet.
						//............................
						GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

						__asm
						{
							add		eax,edx
							add		eax,CTB_SIZE
							mov		dwN1PcktLength,eax
						}
						CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,dwN1PcktLength);
						__asm
						{
							mov		eax,dwN1PcktLength
							add		lpKeyBufferDup3,eax
							add		lpKeyBufferDup4,eax
							add		dwSizeNewKey,eax
						}
						// Add a trust packet to the signature.
						//.....................................
						CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);
						__asm
						{
							add		lpKeyBufferDup4,TRUST_PCKT_SIZE
							add		dwSizeNewKey,TRUST_PCKT_SIZE
						}
					}
				}	// while(TRUE)
			}
		}
		else
		{
			// Not a trust or user id, so we skip it. Signatures
			// are taken care of with the user ids.
			//..................................................
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup3
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup3,edi
			}
		}	
	}	// while(TRUE)

	// Check the old key to see if we have any user ids and
	// associated sigs not transferred. Start address of
	// first user id in lpKeyBufferDup1.
	//.....................................................
	EndOfPublicKey:

	while(TRUE)
	{
		// Check for end of the key.
		//..........................
		if (*lpKeyBufferDup1 == 0)
		{
			break;
		}
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		// Skip trust packets, etc.
		//.........................
		if (TempCTB != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
		}
		else
		{
			// Process user ids.
			//..................
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		dwTempEAX,eax
				add		eax,edx
				add		eax,CTB_SIZE
				mov		dwN1PcktLength,eax
			}
			// Do not copy this user id and associated sigs if the
			// NO_COPY_BIT is set or user id greater than max.
			//....................................................
			if (dwCtb_Byte & NO_COPY_BIT || dwTempEAX > MAX_USER_ID)
			{
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup1,eax
				}
				// Get past the sigs and trust packets for this
				// user id.
				//.............................................
				while(TRUE)
				{	
					// Check for end of this key.
					//...........................
					if (*lpKeyBufferDup1 == 0)
					{
						break;
					}
					__asm
					{
						mov		edi,lpKeyBufferDup1
						mov		al,byte ptr [edi]
						mov		cl,al
						mov		dwCtb_Byte,ecx
						and		al,CTB_MASK
						mov		TempCTB,al
					}
					// We found the next user id.
					//...........................
					if (TempCTB == CTB_USER_ID)
					{
						break;
					}
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpKeyBufferDup1,edi
					}
				}	// while(TRUE)
			}
			else
			{
				// Transfer the user id and associated signatures.
				//................................................
				CopyMemory(lpKeyBufferDup4,lpKeyBufferDup1,dwN1PcktLength);
				__asm
				{
					mov		eax,dwN1PcktLength
					add		lpKeyBufferDup4,eax
					add		lpKeyBufferDup1,eax
					add		dwSizeNewKey,eax
				}
				// Add a trust packet for this user id.
				//.....................................
				CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);

				__asm
				{
					add		lpKeyBufferDup4,TRUST_PCKT_SIZE
					add		dwSizeNewKey,TRUST_PCKT_SIZE
				}
				// Now add the signatures for this user id, if any.
				//.................................................
				while(TRUE)
				{
					// Check for end of key.
					//......................
					if (*lpKeyBufferDup1 == 0)
					{
						break;
					}
					__asm
					{
						mov		edi,lpKeyBufferDup1
						mov		al,byte ptr [edi]
						mov		cl,al
						mov		dwCtb_Byte,ecx
						and		al,CTB_MASK
						mov		TempCTB,al
					}
					if (TempCTB == CTB_USER_ID)
					{
						break;
					}
					if (TempCTB == CTB_SKE_PACKET)
					{
						GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

						__asm
						{
							add		eax,edx
							add		eax,CTB_SIZE
							mov		dwN1PcktLength,eax
						}
						CopyMemory(lpKeyBufferDup4,lpKeyBufferDup1,dwN1PcktLength);

						__asm
						{
							mov		eax,dwN1PcktLength
							add		lpKeyBufferDup1,eax
							add		lpKeyBufferDup4,eax
							add		dwSizeNewKey,eax
						}
						// Add our own trust packet.
						//..........................
						CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);

						__asm
						{
							add		lpKeyBufferDup4,TRUST_PCKT_SIZE
							add		dwSizeNewKey,TRUST_PCKT_SIZE
						}
					}
					else
					{
						// Skip trust packets, etc.
						//.........................
						GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

						__asm
						{
							mov		edi,lpKeyBufferDup1
							add		edi,CTB_SIZE
							add		edi,edx
							add		edi,eax
							mov		lpKeyBufferDup1,edi
						}
					}
				}	// while(TRUE)
			}
		}
	}	// while(TRUE)

	bResult = TRUE;

	MergeEnd:
	return(bResult);
}

// MergeSignatures merges signatures for identical user ids from the
// source file and the old key ring.
//
// Entry: lpKeyBufferDup3 points to the next packet in the 
//        source file. Most likely a trust packet following the
//        user id, or the end of the key.
//
//        lpN1Ptr points to the first signature after the user id in
//        the old key ring, or the next user id, or the end of the key.
//
//        lpNextUserId points to the next user id in the old key ring
//        or the end of the key. If the pointers for lpN1Ptr and 
//        lpNextUserId are the same, no signatures in the old key
//        ring.
//
// Exit:  lpKeyBufferDup3 points to the next user id in the key or
//        the end of the key.
//.....................................................................
VOID MergeSignatures()
{
	DWORD		dwSig1Length;
	LPBYTE		lpRsa1Ptr;
	DWORD		dwRsa1Bits;
	LPBYTE		lpOldSigPtr;
	DWORD		dwSig2Length;
	DWORD		dwCtb_Byte;
	DWORD		dwErrorCode;
	DWORD		dwCompareResult;
	DWORD		dwTempEAX;
	LPBYTE		lpTempEDI;
	BOOL		bXferSig;
	BOOL		bNoMatch;
	BYTE		TempCTB;
	BYTE		TempByte;

	lpOldSigPtr = lpN1Ptr;

	while(TRUE)
	{
		// Check for end of key.
		//......................
		if (*lpKeyBufferDup3 == 0)
		{
			break;
		}
		__asm
		{
			mov		edi,lpKeyBufferDup3
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		// Next user id?
		//..............
		if (TempCTB == CTB_USER_ID)
		{
			break;
		}
		// Skip all packets except signature packets.
		//...........................................
		if (TempCTB != CTB_SKE_PACKET)
		{
			GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup3
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup3,edi
			}
			continue;
		}
		// The only type of packet left is the signature packet.
		//......................................................
		GetPcktLength(lpKeyBufferDup3,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup3
			add		edi,CTB_SIZE
			add		eax,edx
			add		eax,CTB_SIZE
			mov		dwSig1Length,eax
			add		edi,edx
			mov		lpTempEDI,edi
		}
		// If the wrong version we skip this signature.
		//.............................................
		if (*lpTempEDI != VERSION_OLD && *lpTempEDI != VERSION_NEW)
		{
			dwErrorCode = IDS_UNSUPPORTEDVERSIONSIG;
			
		  SkipSignature:
			SetLastError(dwErrorCode);
			ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);

			__asm
			{
				mov		eax,dwSig1Length
				add		lpKeyBufferDup3,eax
			}
			continue;
		}
		lpTempEDI += VERSION_SIZE;
		if (*lpTempEDI != SKE_APPEND_LGTH && *lpTempEDI != SKE_SHA_APPEND_LGTH)
		{
			dwErrorCode = IDS_UNSUPPORTEDVERSIONSIG;
			goto SkipSignature;
		}
		lpTempEDI++;

		// Do we have a valid signature for a user id.
		//............................................
		if (*lpTempEDI < KEY_CERT_GEN || *lpTempEDI > KEY_CERT_SELF)
		{
			dwErrorCode = IDS_UNKNOWNSIGNATURETYPE;
			goto SkipSignature;
		}
		lpTempEDI += (TIMESTAMP_SIZE+1);

		// Save the signature id.
		//.......................
		__asm
		{
			mov		edi,lpTempEDI
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr SigId1,eax
			mov		dword ptr SigId1[4],edx
			add		lpTempEDI,KEY_ID_SIZE
		}
		// If not rsa algorithm, skip this signature.
		//...........................................
		__asm
		{
			mov		edi,lpTempEDI
			mov		al,byte ptr [edi]
			cmp		bConvertedFile,1
			je		L1
			and		al,0x01
		L1:	mov		TempByte,al
		}
		if (TempByte != RSA_ALGORITHM)
		{
			dwErrorCode = IDS_UNKNOWNSIGNATURETYPE;
			goto SkipSignature;
		}
		lpTempEDI += ALGORITHM_SIZE;

		// If not MD5, Sha1, or Sha512 message digest, skip this signature.
		//.................................................................
		if (*lpTempEDI != MD5_ALGORITHM && *lpTempEDI != SHA_ALGORITHM && 
			*lpTempEDI != SHA512_ALGORITHM)
		{
			dwErrorCode = IDS_NONMD5ALGORITHMINSIG;
			goto SkipSignature;
		}
		// Set up a pointer to the rsa encrypted integer.
		//...............................................
		__asm
		{
			mov		edi,lpTempEDI
			add		edi,3
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwRsa1Bits,eax
			add		edi,MPI_PREFIX_SIZE
			mov		lpRsa1Ptr,edi

			// See if we have a matching signature in the old key
			// now that this one checks our so far.
			//...................................................
			mov		bXferSig,TRUE
			mov		bNoMatch,TRUE
		}
		lpTempEDI = lpN1Ptr;

		while(TRUE)
		{
			if (lpTempEDI >= lpNextUserId)
			{
				break;
			}
			// No more sigs to check if end of key.
			//.....................................
			if (*lpTempEDI == 0)
			{
				break;
			}
			__asm
			{
				mov		edi,lpTempEDI
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		TempCTB,al
			}
			if (TempCTB == CTB_TRUST)
			{
				lpTempEDI += TRUST_PCKT_SIZE;
				continue;
			}
			// If not a trust packet, has to be signature packet.
			//...................................................
			lpOldSigPtr = lpTempEDI;
			GetPcktLength(lpTempEDI,dwCtb_Byte);

			__asm
			{
				mov		edi,lpTempEDI
				add		edi,CTB_SIZE
				add		eax,edx
				add		eax,CTB_SIZE
				mov		dwSig2Length,eax
				add		edi,edx
				mov		lpTempEDI,edi
			}
			// If this signature has already been marked for no copy,
			// we can skip it and try the next signature.
			//.......................................................
			if (dwCtb_Byte & NO_COPY_BIT)
			{
				__asm
				{
					mov		edi,lpOldSigPtr
					add		edi,dwSig2Length
					mov		lpTempEDI,edi
				}
				continue;
			}
			lpTempEDI += (TIMESTAMP_SIZE+3);

			// See if the signatures have the same key id.
			//............................................
			dwCompareResult = MpCompareDW(lpTempEDI,(LPBYTE)&SigId1,2);

			// We have a match.
			//.................
			if (dwCompareResult == 0)
			{
				__asm
				{
					mov		edi,lpTempEDI
					add		edi,12
					movzx	eax,word ptr [edi]
					xchg	ah,al
					mov		dwTempEAX,eax
					add		edi,MPI_PREFIX_SIZE
					mov		lpTempEDI,edi
				}
				if (dwTempEAX != dwRsa1Bits)
				{
				  NoTransfer:
					SetLastError(IDS_MATCHINGSIGSWITHDIFFERENTRSAINTEGERS);
					ErrorProcedure(szKeyFile,IDS_ADDKEYPROC,MB_OK);
					bXferSig = FALSE;
					break;
				}
				// Bits to bytes.
				//...............
				__asm
				{
					mov		ecx,dwTempEAX
					add		ecx,7
					shr		ecx,3
					mov		edi,lpTempEDI
					mov		esi,lpRsa1Ptr
					repe	cmpsb
					jne		NoTransfer

					// They are equal. Mark the old one for no
					// transfer.
					//........................................
					mov		edi,lpOldSigPtr
					or		byte ptr [edi],NO_COPY_BIT
					mov		bNoMatch,FALSE
				}
				break;
			}
			else
			{
				// No match for this one. Try the next.
				//.....................................
				__asm
				{
					mov		edi,lpOldSigPtr
					add		edi,dwSig2Length
					mov		lpTempEDI,edi
				}
			}
		}	// while(TRUE)

		// If signature is OK transfer it to the new key
		// in lpKeyBufferDup4,
		//..............................................
		if (bXferSig)
		{
			CopyMemory(lpKeyBufferDup4,lpKeyBufferDup3,dwSig1Length);

			__asm
			{
				mov		eax,dwSig1Length
				add		lpKeyBufferDup4,eax
				add		dwSizeNewKey,eax
			}
			CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);

			__asm
			{
				add		lpKeyBufferDup4,TRUST_PCKT_SIZE
				add		dwSizeNewKey,TRUST_PCKT_SIZE
			}
			if (bNoMatch)
			{
				bNewStuffAdded = TRUE;
			}
		}
		// See if we have any more signatures.
		//....................................
		__asm
		{
			mov		eax,dwSig1Length
			add		lpKeyBufferDup3,eax
		}
	}
	// Check for any old unmatched signatures and transfer them.
	//..........................................................
	lpTempEDI = lpN1Ptr;

	while(TRUE)
	{
		// End of this group of sigs for the user id?
		//...........................................
		if (lpTempEDI >= lpNextUserId)
		{
			break;
		}
		// End of this key.
		//.................
		if (*lpTempEDI == 0)
		{
			break;
		}
		__asm
		{
			mov		edi,lpTempEDI
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		// Trust or any other packet we skip.
		//...................................
		if (TempCTB != CTB_SKE_PACKET)
		{
			GetPcktLength(lpTempEDI,dwCtb_Byte);

			__asm
			{
				mov		edi,lpTempEDI
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpTempEDI,edi
			}
			continue;
		}
		// We have a signature packet.
		//............................
		lpOldSigPtr = lpTempEDI;
		GetPcktLength(lpTempEDI,dwCtb_Byte);

		__asm
		{
			add		eax,edx
			add		eax,CTB_SIZE
			mov		dwSig2Length,eax
		}
		// Do not copy this one if the NO_COPY_BIT is set.
		//................................................
		if (dwCtb_Byte & NO_COPY_BIT)
		{
			__asm
			{
				mov		edi,lpOldSigPtr
				add		edi,dwSig2Length
				mov		lpTempEDI,edi
			}
			continue;
		}
		// Copy this signature to the new key buffer.
		//...........................................
		CopyMemory(lpKeyBufferDup4,lpOldSigPtr,dwSig2Length);

		__asm
		{
			mov		eax,dwSig2Length
			add		lpKeyBufferDup4,eax
			add		dwSizeNewKey,eax
		}
		// Add our trust packet to the signature.
		//.......................................
		CopyMemory(lpKeyBufferDup4,&TrustPacket,TRUST_PCKT_SIZE);

		__asm
		{
			add		lpKeyBufferDup4,TRUST_PCKT_SIZE
			add		dwSizeNewKey,TRUST_PCKT_SIZE
		}
		// See if we have any more signatures to check.
		//.............................................
		__asm
		{
			mov		edi,lpOldSigPtr
			add		edi,dwSig2Length
			mov		lpTempEDI,edi
		}
	}	// while(TRUE)
}
